#include "Arduino.h"
#include "KeyBoard.h"

KeyBoard::KeyBoard(unsigned short ROW_1, unsigned short ROW_2, unsigned short ROW_3, unsigned short ROW_4, unsigned short COL_1, unsigned short COL_2, unsigned short COL_3, unsigned short COL_4){
    _ROW[0] = ROW_1;
    _ROW[1] = ROW_2;
    _ROW[2] = ROW_3;
    _ROW[3] = ROW_4;
    _COL[0] = COL_1;
    _COL[1] = COL_2;
    _COL[2] = COL_3;
    _COL[3] = COL_4;
    lastkey = newkey = 0;

    for(int i=0; i<4; i++)
        pinMode(_ROW[i], INPUT_PULLUP);


    for(int i=0; i<4; i++) {
        digitalWrite(_COL[i], LOW);
        pinMode(_COL[i], OUTPUT);
    }
}

bool KeyBoard::available() {
    for(int i=0; i<4; i++) {
        digitalWrite(_COL[i], LOW);
        pinMode(_COL[i], OUTPUT);
    }

    delay(1);
    bool key = !digitalRead(_ROW[0]) || !digitalRead(_ROW[1]) || !digitalRead(_ROW[2]) || !digitalRead(_ROW[3]);

    if (!key)
        newkey = 0;

    return (key);
}

unsigned short KeyBoard::gethwkey() {
    unsigned short key = 0;

    for(int i=0; i<4; i++) {
        digitalWrite(_COL[0], i != 0);
        digitalWrite(_COL[1], i != 1);
        digitalWrite(_COL[2], i != 2);
        digitalWrite(_COL[3], i != 3);
        key = key << 4;
        key |= ((digitalRead(_ROW[0])<<0) | (digitalRead(_ROW[1])<<1) | (digitalRead(_ROW[2])<<2) |  (digitalRead(_ROW[3])<<3));
    }

    for(int i=0; i<4; i++)
        digitalWrite(_COL[i], LOW);

    return (~key);
}

char KeyBoard::read() {
    const char read[16] = {'D', 'C', 'B', 'A', '#', '9', '6', '3', '0', '8', '5', '2', '*', '7', '4', '1'};
    unsigned short mask = 1;

    if (lastkey == 0) {
        unsigned short key = gethwkey();
        if (newkey != key)
            lastkey = newkey = key;
    }

    for (int i = 0; i<16; i++) {
	if (lastkey & mask) {
	    lastkey &= ~mask;
	    return read[i];
	}
	mask = mask << 1;
    }

    return (0);
};


