#include "Arduino.h"
#include "Dimmer.h"

Dimmer::Dimmer(unsigned short pin){
    Dimmer::pin = pin;
    Dimmer::duration = 0;
    Dimmer::time = 0;
    Dimmer::pwm = 255;
}

void Dimmer::on(unsigned char pwm, unsigned long timeout, unsigned short duration) {
    Dimmer::pwm = ~pwm;
    Dimmer::duration = duration;
    Dimmer::time = millis() + timeout;

    analogWrite(pin, ~pwm);
}

bool Dimmer::available() {
    unsigned long now = millis();

    return (pwm > 0 && time < now);
}

bool Dimmer::dimming() {
    unsigned long now = millis();
    unsigned char value = map(min(now, time+duration), min(now, time), time+duration, pwm, 255);

    if ( value == 255)
        pwm = 0;

    delay(10);
    analogWrite(pin, value);

    return (value == 255);
};


